/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import io.github.foundationgames.automobility.Automobility;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SingleSlotScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;

    public SingleSlotScreenHandler(int syncId, Inventory playerInv) {
        this(syncId, playerInv, (Container)new SimpleContainer(1));
    }

    public SingleSlotScreenHandler(int syncId, Inventory playerInv, Container inv) {
        super(Automobility.SINGLE_SLOT_SCREEN.require("Single slot screen not registered!"), syncId);
        int row;
        SingleSlotScreenHandler.checkContainerSize((Container)inv, (int)1);
        this.inventory = inv;
        inv.startOpen(playerInv.player);
        this.addSlot(new Slot(this.inventory, 0, 80, 23));
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 58 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.addSlot(new Slot((Container)playerInv, row, 8 + row * 18, 116));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int fromSlotId) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot fromSlot = (Slot)this.slots.get(fromSlotId);
        if (fromSlot.hasItem()) {
            ItemStack fromStack = fromSlot.getItem();
            newStack = fromStack.copy();
            if (fromSlotId == 0 ? !this.moveItemStackTo(fromStack, 1, 37, true) : !this.moveItemStackTo(fromStack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (fromStack.isEmpty()) {
                fromSlot.set(ItemStack.EMPTY);
            } else {
                fromSlot.setChanged();
            }
        }
        return newStack;
    }
}

